IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GT_MOSTRA_DETALHE_TRIBUTACAO]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_GT_MOSTRA_DETALHE_TRIBUTACAO]
GO


CREATE PROCEDURE [dbo].[P_GT_MOSTRA_DETALHE_TRIBUTACAO] (@CD_REGIAO_FICAL INT, @CD_PROD INT) AS
BEGIN

	SET NOCOUNT ON

	CREATE TABLE #GT_RETORNO_APLICACAO (
		CD_EMP INT  
		,CD_PROD INT  
		,DS_PROD VARCHAR(150)
		,CD_REGIAO_FISCAL INT  
		,CD_CTR_CABECALHO BIGINT  
		,CD_CTR_PROD BIGINT  
		,CD_PROD_RETORNADO VARCHAR(50)
		,NR_NCM VARCHAR(50)
		,NR_CEST VARCHAR(20)
		,LISTA_PROD VARCHAR(2)
		,TIPO_PROD VARCHAR(2)
		,CTR_PMC VARCHAR(2)
		,IMPOSTO_IMP MONEY  
		,CST_ENT VARCHAR(2)
		,CST_SAI VARCHAR(2)
		,ALIQ_PIS MONEY  
		,ALIQ_COFINS MONEY  
		,NRI VARCHAR(10)
		,APARO_LEGAL VARCHAR(1000)
		,UF VARCHAR(2)
		,CFOP VARCHAR(10)
		,TP_MOV INT
		,DS_MOV VARCHAR(150) 
		,CD_CTR_REGRA_UF BIGINT  
		,CD_CARAC INT
		,CD_OPER_MVA INT
		,DS_OPER_MVA VARCHAR(50)
		,FINALIDADE SMALLINT  
		,CFOPST VARCHAR(10)
		,CST INT
		,CD_TRIB_CST INT
		,CSOSN VARCHAR(10)
		,ALIQ_ICMS_INTERNA MONEY  
		,ALIQ_ICMS_INTER_EST MONEY  
		,PERC_REDU_BC MONEY  
		,PERC_REDU_BC_ST MONEY  
		,PERC_REDU_BC_INTER_EST MONEY  
		,ALIQ_ICMS_ST MONEY  
		,PERC_IVA MONEY  
		,PERC_IVA_AJUSTADO MONEY  
		,PERC_FCP MONEY  
		,CD_BENEF VARCHAR(50)
		,PERC_DIFERIMENTO MONEY  
		,PERC_ISENCAO MONEY  
		,ANTECIPADO CHAR  
		,DESONERADO CHAR  
		,ISENTO CHAR  
		,AMP_LEGAL VARCHAR(1000)
		,SIMPLES_NACIONAL TINYINT)
			
	INSERT INTO
		#GT_RETORNO_APLICACAO
	SELECT
		EST_PROD.CD_EMP
		,EST_PROD.CD_PROD
		,EST_PROD.DS_PROD
		,PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE.CD_CTR AS CD_CTR_CABECALHO

		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR AS CD_CTR_PROD
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_PROD_RETORNADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.NR_NCM
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.NR_CEST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.LISTA_PROD
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.TIPO_PROD
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CTR_PMC
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.IMPOSTO_IMP
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CST_ENT
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CST_SAI
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.ALIQ_PIS
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.ALIQ_COFINS
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.NRI
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.APARO_LEGAL
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.UF
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CFOP
		,-1 AS TP_MOV
		,'' AS DS_MOV
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CTR_REGRA_UF
		,CASE WHEN ISNUMERIC(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CARAC) = 1 THEN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CARAC ELSE 0 END AS CD_CARAC
		,-1 AS CD_OPER_MVA
		,'' AS DS_OPER_MVA
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.FINALIDADE
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CFOPST
		,CASE WHEN ISNUMERIC(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CST) = 1 THEN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CST ELSE 0 END AS CST
		,-1 AS CD_TRIB_CST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CSOSN
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ALIQ_ICMS_INTERNA
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ALIQ_ICMS_INTER_EST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_REDU_BC
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_REDU_BC_ST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_REDU_BC_INTER_EST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ALIQ_ICMS_ST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_IVA
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_IVA_AJUSTADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_FCP
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_BENEF
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_DIFERIMENTO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_ISENCAO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ANTECIPADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.DESONERADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ISENTO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.AMP_LEGAL

		,CASE WHEN GT_ENVIO_PERFIL_DEST.SIMPLES_NACIONAL = 'S' THEN 1 ELSE 0 END AS SIMPLES_NACIONAL
	FROM 
		GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE.CD_CTR 
		INNER JOIN EST_PROD ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_EMP = EST_PROD.CD_EMP 
			AND GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_PROD = EST_PROD.CD_PROD 
		INNER JOIN GT_RETORNO_CABECALHO ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR_RETORNO = GT_RETORNO_CABECALHO.CD_CTR 
		INNER JOIN GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO ON 
			GT_RETORNO_CABECALHO.CD_CTR = GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO.CD_CTR_RETORNO 
		INNER JOIN GT_ENVIO_EMITENTE ON 
			GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO.CD_CTR_ENVIO = GT_ENVIO_EMITENTE.CD_CTR 
		INNER JOIN GT_ENVIO_PERFIL_DEST ON 
			GT_ENVIO_EMITENTE.CD_CTR = GT_ENVIO_PERFIL_DEST.CD_CTR_ENVIO 
		INNER JOIN PRC_REGIAO_FISCAL ON 
			GT_ENVIO_EMITENTE.CD_REGIAO_FISCAL = PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_EAN ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_EAN.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_IPI ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_IPI.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CD_CTR_REGRA 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CTR_REGRA_UF 
			AND GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CFOP = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CFOP  -- critrio acrescentado para resolver erro de duplicidade.
	WHERE
		EST_PROD.CD_EMP = 1
		AND PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL = @CD_REGIAO_FICAL
		AND EST_PROD.CD_PROD = @CD_PROD

	--ATUALIZANDO O CDIGO DA CST PELA TABELA EST_TRIB_CST
	--NO FOI COLOCADO NO INNER JOIN PORQUE PODE DUPLICAR OS REGISTROS
	UPDATE
		RET_TRIB
	SET
		CD_TRIB_CST = CST.CD_TRIB_CST
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN EST_TRIB_CST CST ON 
			RET_TRIB.CST = CST.CD_TRIB_CST
			
	--ATUALIZANDO O CDIGO DA CD_OPER_MVA PELA TABELA EST_TRIB_OPER_MVA
	--NO FOI COLOCADO NO INNER JOIN PORQUE PODE DUPLICAR OS REGISTROS
	UPDATE
		RET_TRIB
	SET
		CD_OPER_MVA = MVA.CD_OPER_MVA,
		DS_OPER_MVA = CAST(MVA.CD_OPER_MVA AS VARCHAR(20)) + ' - ' + MVA.DS_OPER_MVA
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN EST_TRIB_OPER_MVA MVA ON 
			RET_TRIB.CD_CARAC = MVA.CARAC_TRIB
			
	--ATUALIZANDO TP_MOV PELA TABELA GLB_NT_OP_PROD
	--NO FOI COLOCADO NO INNER JOIN PORQUE PODE DUPLICAR OS REGISTROS
	UPDATE
		RET_TRIB
	SET
		TP_MOV = CFOP.TP_MOV,
		DS_MOV = GLB_MOV_OP_TP_MOV.DS_MOV
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN GLB_NT_OP_PROD CFOP ON 
			RIGHT(RET_TRIB.CFOP, 3) = CAST(CFOP.NR_CFOP_PROD AS VARCHAR(10)) COLLATE SQL_Latin1_General_CP1_CI_AS
			AND CFOP.ORIG_DEST IN (0 ,3)
			AND CFOP.TP_MOV_OP_TRANSA IN (SELECT CASE WHEN LEFT(RET_TRIB.CFOP, 1) IN (5, 6) THEN 1 ELSE 0 END UNION SELECT 2)
			AND CFOP.STS = 0
		INNER JOIN GLB_MOV_OP_TP_MOV ON
			CFOP.TP_MOV = GLB_MOV_OP_TP_MOV.TP_MOV
	
	SET NOCOUNT OFF

	SELECT
		RET_TRIB.CD_TRIB_CST
		,EST_TRIB_CST.DS_TRIB_CST
		,RET_TRIB.UF
		,RET_TRIB.TP_MOV
		,RET_TRIB.DS_MOV
		,CASE WHEN LEFT(RET_TRIB.CFOP, 1) IN (1,2) THEN 
			0
		ELSE
			1
		END AS TP_TRANSA
		,CASE WHEN LEFT(RET_TRIB.CFOP, 1) IN (1,2) THEN 
			'0 - Entrada'
		ELSE
			'1 - Sada' 
		END AS DS_TP_TRANSA
		,CASE RET_TRIB.LISTA_PROD 
			WHEN 'P' THEN 'POSITIVA'
			WHEN 'N' THEN 'NEGATIVA'
			WHEN 'U' THEN 'NEUTRA'
			WHEN 'O' THEN 'NAO DEFINIDO'
			ELSE 'NAO DEFINIDO'
		END AS TP_LISTA
		,0 AS TP_RED_BASE_IMP
		,'0 - SOMENTE BASE ICMS' AS DS_TP_RED_BASE_IMP
		,RET_TRIB.PERC_REDU_BC AS PERC_RED
		,RET_TRIB.PERC_REDU_BC_ST AS PERC_RED_SUBS_TRIB
		,0 AS PERC_RED_ESTORNO
		,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS
		,0 AS PERC_REPASSE
		,0 AS PERC_IBPT
		,3 AS TP_GERACAO_DARE
		,'3 - No gerar DARE/DAE/GNRE' AS DS_TP_GERACAO_DARE
		,CASE WHEN RET_TRIB.PERC_IVA_AJUSTADO <= 0 THEN '0 - No' ELSE '1 - SIM' END AS MVA_AJUSTADO
		,RET_TRIB.CD_OPER_MVA
		,RET_TRIB.DS_OPER_MVA
		,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS_ORIGEM
		,0 AS PERC_RED_IMPORTADO
		,0 AS PERC_RED_SUBS_TRIB_IMPORTADO
		,RET_TRIB.SIMPLES_NACIONAL AS TIPO_REGIME_EMPRESA
		,CASE WHEN RET_TRIB.SIMPLES_NACIONAL = 1 THEN 'Simples nacional' ELSE 'Lucro Presumido\Lucro Real' END AS DS_TIPO_REGIME_EMPRESA
		,'' AS OBS_GRUPO_TRIB_NF
		,0 AS PERC_ICMS_DIFAL_EXCESSAO
		,CASE WHEN RET_TRIB.PERC_FCP = 0 THEN '0 - NO' ELSE '1 - SIM' END AS FCOP
		,RET_TRIB.PERC_DIFERIMENTO AS PERC_DIFERIMENTO
		,RET_TRIB.CFOP
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN EST_TRIB_CST ON 
			RET_TRIB.CD_TRIB_CST = EST_TRIB_CST.CD_TRIB_CST
	ORDER BY
		RET_TRIB.CFOP,
		RET_TRIB.DS_MOV

	SET NOCOUNT ON

	DROP TABLE #GT_RETORNO_APLICACAO
	
END
GO


